package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.call.CallType;
import com.stringee.call.StringeeCall;
import com.stringee.common.StringeeConstant;
import com.stringee.network.tcpclient.packet.Packet;

import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by luannguyen on 8/30/2017.
 */

public class CallStopFromServer extends ProcessorBase {
    @Override
    public void process(final StringeeClient client, final Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            String callId = packet.optFieldString("callId");
            ConcurrentHashMap<String, StringeeCall> callMap = client.getCallMap();
            StringeeCall stringeeCall = callMap.get(callId);
            if (stringeeCall != null) {
                stringeeCall.setState(StringeeCall.SignalingState.ENDED);
                stringeeCall.setCallStatus(StringeeConstant.SIP_CODE_ENDED);
                StringeeCall.StringeeCallListener callListener = stringeeCall.getCallListener();
                if (callListener != null) {
                    if (stringeeCall.getCallType() == CallType.APP_TO_PHONE) {
                        callListener.onSignalingStateChange(stringeeCall, StringeeCall.SignalingState.ENDED, "Ended", -1, "Bye");
                    } else {
                        callListener.onSignalingStateChange(stringeeCall, StringeeCall.SignalingState.ENDED, "Ended", -1, "");
                    }
                }
                stringeeCall.release(true);
            }
        });
    }
}
