package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.exception.StringeeError;
import com.stringee.messaging.ChannelType;
import com.stringee.messaging.ChatRequest;
import com.stringee.messaging.ChatRequest.RequestType;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class ChatRequestLoad extends ProcessorBase {
    @Override
    public void process(final StringeeClient client, final Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                CallbackListener<List<ChatRequest>> listener = Common.callbackListenerMap.get(requestId);
                List<ChatRequest> chatRequests = new ArrayList<>();
                if (r == 0) {
                    JSONArray jsonArray = packet.optFieldJSONArray("chatRequests");
                    if (!Utils.isEmpty(jsonArray)) {
                        for (int i = 0; i < jsonArray.length(); i++) {
                            JSONObject jsonObject = jsonArray.getJSONObject(i);
                            String convId = jsonObject.optString("convId");
                            String customerId = jsonObject.optString("customerId");
                            String type = jsonObject.optString("type");
                            String customerName = jsonObject.optString("customerName");
                            ChannelType channelType = ChannelType.getType(packet.optFieldInt("channelType"));

                            ChatRequest chatRequest = new ChatRequest();
                            chatRequest.setConvId(convId);
                            chatRequest.setCustomerId(customerId);
                            chatRequest.setUserId(client.getUserId());
                            chatRequest.setName(customerName);
                            chatRequest.setChannelType(channelType);
                            if (type.equals("transfer")) {
                                chatRequest.setRequestType(RequestType.TRANSFER);
                            }

                            chatRequests.add(chatRequest);

                            client.getChatRequestMap().put(convId, chatRequest);
                        }

                        if (listener != null) {
                            listener.onSuccess(chatRequests);
                        }
                    } else {
                        if (listener != null) {
                            listener.onError(new StringeeError(-3, "No chat request found."));
                        }
                    }
                } else {
                    if (listener != null) {
                        listener.onError(new StringeeError(r, "Failed to load chat request"));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(ChatRequestLoad.class, e);
            }
        });
    }
}
