package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.event.EventManager;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

public class ChatRequestTimeoutToQueue extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            String convId = packet.optFieldString("convId");
            client.getConversationFromServer(convId, new CallbackListener<Conversation>() {
                @Override
                public void onSuccess(Conversation conversation) {
                    if (conversation != null) {
                        EventManager.sendChatSupportTimeoutInQueueEvent(client, conversation);
                    }
                }
            });
        });
    }
}
