package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class CheckExitsCall extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.optFieldInt("r", -1);
                int requestId = packet.optFieldInt("requestId");
                CallbackListener<Boolean> listener = Common.callbackListenerMap.get(requestId);
                if (r == 0) {
                    boolean exist = packet.getBoolean("exist");
                    if (listener != null) {
                        listener.onSuccess(exist);
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(CheckExitsCall.class, e);
            }
        });
    }
}
