package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.exception.StringeeError;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.StringeeChange;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class CreateConversation extends ProcessorBase {
    @Override
    public void process(final StringeeClient client, final Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                CallbackListener<Conversation> callbackListener = Common.callbackListenerMap.get(requestId);
                if (r == 0 || r == 2) {
                    String convId = packet.optFieldString("convId");
                    client.getConversationFromServer(convId, new CallbackListener<Conversation>() {
                        @Override
                        public void onSuccess(Conversation conversation) {
                            if (callbackListener != null) {
                                callbackListener.onSuccess(conversation);
                            }
                            EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.INSERT, conversation));
                        }

                        @Override
                        public void onError(StringeeError errorInfo) {
                            super.onError(errorInfo);
                            if (callbackListener != null) {
                                callbackListener.onError(new StringeeError(r, "Failed to create a conversation"));
                            }
                        }
                    });
                } else {
                    if (callbackListener != null) {
                        callbackListener.onError(new StringeeError(r, "Failed to create a conversation"));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(CreateConversation.class, e);
            }
        });
    }
}
