package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.exception.StringeeError;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class GetTotalUnread extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(()->{
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                CallbackListener<Integer> listener = Common.callbackListenerMap.get(requestId);
                if (r == 0) {
                    int count = packet.optFieldInt("count");
                    if (listener != null) {
                        listener.onSuccess(count);
                    }
                } else {
                    if (listener != null) {
                        listener.onError(new StringeeError(r, "Failed to get total number of unread conversations."));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(GetTotalUnread.class, e);
            }
        });
    }
}
