package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.database.DBHandler;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.Message;
import com.stringee.messaging.StringeeChange;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class PinMessage extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                boolean isPin = packet.getBoolean("isPin");
                StatusListener statusListener = Common.statusListenerMap.get(requestId);
                DBHandler dbHandler = DBHandler.getInstance(client.getContext());
                if (r == 0) {
                    if (statusListener != null) {
                        statusListener.onSuccess();
                    }
                    Message message = client.getMessagesMap().get(requestId);
                    if (message != null) {
                        Conversation conversation = dbHandler.getConversationByRemoteId(message.getConversationId(), client.getUserId());
                        if (conversation != null) {
                            if (isPin) {
                                conversation.setPinnedMsgId(message.getId());
                            } else {
                                conversation.setPinnedMsgId("");
                            }
                            client.executeDbExecutor(() -> dbHandler.updateConversation(conversation));
                            EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.UPDATE, conversation));
                        }
                        client.getMessagesMap().remove(requestId);
                    }
                } else {
                    if (statusListener != null) {
                        statusListener.onError(new StringeeError(r, packet.getFieldString("message")));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(PinMessage.class, e);
            }
        });
    }
}
