package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.database.DBHandler;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.StringeeChange;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class PinMessageFromServer extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                String msgId = packet.getFieldString("msgId");
                String convId = packet.getFieldString("convId");
                boolean isPin = packet.getBoolean("isPin");
                DBHandler dbHandler = DBHandler.getInstance(client.getContext());
                Conversation conversation = dbHandler.getConversationByRemoteId(convId, client.getUserId());
                if (conversation != null) {
                    if (isPin) {
                        conversation.setPinnedMsgId(msgId);
                    } else {
                        conversation.setPinnedMsgId("");
                    }
                    client.executeDbExecutor(() -> dbHandler.updateConversation(conversation));
                    EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.UPDATE, conversation));
                }
            } catch (JSONException e) {
                Utils.reportException(PinMessageFromServer.class, e);
            }
        });
    }
}
