package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class RateChat extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                StatusListener listener = Common.statusListenerMap.get(requestId);
                if (r == 0) {
                    if (listener != null) {
                        listener.onSuccess();
                    }
//                        String convId = packet.getFieldString("convId");
//                        String endedBy = packet.optFieldString("endedby");
//                        com.stringee.database.DBHandler dbHandler = com.stringee.database.DBHandler.getInstance(client.getContext());
//                        com.stringee.messaging.Conversation conversation = dbHandler.getConversationByRemoteId(convId, client.getUserId());
//                        if (conversation != null) {
//                            if (!conversation.isEnded()) {
//                                conversation.setEnded(true);
//                                dbHandler.updateConversation(conversation);
//                                com.stringee.messaging.User user = null;
//                                if (com.stringee.common.Utils.isTextEmpty(endedBy)) {
//                                    user = dbHandler.getUser(client.getUserId());
//                                } else {
//                                    user = dbHandler.getUser(endedBy);
//                                }
//                                com.stringee.messaging.listeners.LiveChatEventListener liveChatEventListener = client.getLiveChatEventListener();
//                                if (liveChatEventListener != null) {
//                                    liveChatEventListener.onConversationEnded(conversation, user);
//                                }
//                            }
//                        }
                } else {
                    if (listener != null) {
                        listener.onError(new StringeeError(r, packet.optFieldString("message", "")));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(RateChat.class, e);
            }
        });
    }
}
