package com.stringee.network.processor;

import android.content.Context;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Constant;
import com.stringee.common.PrefUtils;
import com.stringee.common.Utils;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by luannguyen on 2/2/2018.
 */

public class RegisterPushToken extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                String desc;
                Context context = client.getContext();
                String packageName = context.getPackageName();
                String key = Constant.PUSH_REGISTER + "_" + packageName;
                String status;
                boolean success = false;
                if (r == 0 || r == 2) {
                    success = true;
                    status = Constant.REGISTERED;
                    desc = "Push token is registered successfully.";
                } else {
                    status = Constant.FAILED;
                    desc = "Fail to register push token. Package name is not configured.";
                }

                StatusListener listener = Common.statusListenerMap.get(requestId);
                if (listener != null) {
                    if (success) {
                        listener.onSuccess();
                    } else {
                        listener.onError(new StringeeError(r, desc));
                    }
                }

                String data = PrefUtils.getInstance(context).getString(key);
                if (data != null) {
                    JSONObject jsonObject = new JSONObject(data);
                    String token = jsonObject.getString(Constant.TOKEN);
                    PrefUtils.getInstance(context).savePushToken(key, token, status);
                }
            } catch (JSONException e) {
                Utils.reportException(RegisterPushToken.class, e);
            }
        });
    }
}
