package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;
import org.json.JSONObject;

public class SubscribeFromServer extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            JSONObject jsonObject = packet.getJsonData();
            try {
                JSONObject messageObject = jsonObject.getJSONObject("message");
                String userId = messageObject.optString("userId", "");
                EventManager.sendClientTopicMsgEvent(client, userId, jsonObject);
            } catch (JSONException e) {
                Utils.reportException(SubscribeFromServer.class, e);
            }
        });
    }
}
