package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class TransferCall extends ProcessorBase {

    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");

                StatusListener listener = Common.statusListenerMap.get(requestId);
                if (listener != null) {
                    if (r == 0) {
                        listener.onSuccess();
                    } else {
                        String error = "Failed to transfer the call.";
                        switch (r) {
                            case 1:
                                error = "Call not found.";
                                break;
                            case 2:
                                error = "User is null.";
                                break;
                            case 3:
                                error = "User not in call.";
                                break;
                            case 4:
                                error = "Json error";
                                break;
                            case 5:
                                error = "User id is null";
                                break;
                            case 6:
                                error = "This is not a call.";
                                break;
                        }
                        listener.onError(new StringeeError(r, error));
                    }
                    Common.statusListenerMap.remove(requestId);
                }
            } catch (JSONException e) {
                Utils.reportException(TransferCall.class, e);
            }
        });
    }
}
