package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.database.DBHandler;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.StringeeChange;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class TransferChat extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                StatusListener statusListener = Common.statusListenerMap.get(requestId);
                if (r == 0) {
                    if (statusListener != null) {
                        statusListener.onSuccess();
                    }
                    String convId = packet.getFieldString("convId");
                    DBHandler dbHandler = DBHandler.getInstance(client.getContext());
                    Conversation conversation = dbHandler.getConversationByRemoteId(convId, client.getUserId());
                    if (conversation != null) {
                        client.executeDbExecutor(() -> dbHandler.deleteConversationByConvId(convId, client.getUserId()));
                        EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.DELETE, conversation));
                    }
                } else {
                    if (statusListener != null) {
                        statusListener.onError(new StringeeError(r, packet.optFieldString("message", "Error")));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(TransferChat.class, e);
            }
        });
    }
}