package com.stringee.network.processor;

import android.content.Context;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Constant;
import com.stringee.common.PrefUtils;
import com.stringee.common.Utils;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by luannguyen on 2/2/2018.
 */

public class UnregisterPushToken extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                String desc = "";
                boolean success = false;
                if (r == 0) {
                    success = true;
                    desc = "Push token is unregistered successfully.";
                    Context context = client.getContext();
                    String data = PrefUtils.getInstance(context).getString(Constant.PUSH_UNREGISTER);
                    if (data != null) {
                        try {
                            JSONArray jsonArray = new JSONArray(data);
                            JSONArray newArray = new JSONArray();
                            String username = context.getPackageName() + "." + client.getProjectId() + "." + client.getUserId();
                            for (int i = jsonArray.length() - 1; i >= 0; i--) {
                                JSONObject jsonObject = jsonArray.getJSONObject(i);
                                String id = jsonObject.getString(Constant.USER_NAME);
                                if (!id.equals(username)) {
                                    newArray.put(jsonObject);
                                }
                            }
                            if (!Utils.isEmpty(newArray)) {
                                PrefUtils.getInstance(context).putString(Constant.PUSH_UNREGISTER, newArray.toString());
                            } else {
                                PrefUtils.getInstance(context).remove(Constant.PUSH_UNREGISTER);
                            }
                        } catch (JSONException e) {
                            Utils.reportException(UnregisterPushToken.class, e);
                        }

                    }
                } else if (r == 1) {
                    desc = "Fail to unregister push token. Package name is not configured.";
                } else if (r == 2) {
                    desc = "Fail to unregister push token. Device token does not exist.";
                }

                int projectId = packet.optFieldInt("projectId");
                String userId = packet.optFieldString("userId");
                if (projectId == client.getProjectId() && userId.equals(client.getUserId())) {
                    StatusListener listener = Common.statusListenerMap.get(requestId);
                    if (listener != null) {
                        if (success) {
                            listener.onSuccess();
                        } else {
                            listener.onError(new StringeeError(r, desc));
                        }
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(UnregisterPushToken.class, e);
            }
        });
    }
}
