package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.call.StringeeCall2;
import com.stringee.call.StringeeCall2.EndCallCause;
import com.stringee.common.StringeeConstant;
import com.stringee.listener.StatusListener;
import com.stringee.network.tcpclient.packet.Packet;
import com.stringee.video.StringeeRoom;
import com.stringee.video.StringeeVideoTrack;

import org.json.JSONException;

import java.util.List;

public class VideoCallStateChange extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                String callId = packet.getFieldString("callId");
                int code = packet.getFieldInt("code");
                StringeeCall2.SignalingState callState = StringeeCall2.SignalingState.CALLING;
                String reason = "";
                switch (code) {
                    case StringeeConstant.SIP_CODE_CONNECTING:
                        reason = "Calling";
                        break;
                    case StringeeConstant.SIP_CODE_SESSION_IN_PROGRESS:
                    case StringeeConstant.SIP_CODE_RINGING:
                        callState = StringeeCall2.SignalingState.RINGING;
                        reason = "Ringing";
                        break;
                    case StringeeConstant.SIP_CODE_OK:
                        callState = StringeeCall2.SignalingState.ANSWERED;
                        reason = "Starting";
                        break;
                    case StringeeConstant.SIP_CODE_BUSY:
                    case StringeeConstant.SIP_CODE_BUSY_2:
                        callState = StringeeCall2.SignalingState.BUSY;
                        reason = EndCallCause.USER_BUSY.getValue();
                        break;
                    default:
                        if (code >= 400) {
                            callState = StringeeCall2.SignalingState.ENDED;
                            reason = EndCallCause.NORMAL.getValue();
                        }
                        break;
                }

                if (callId != null) {
                    StringeeCall2 stringeeCall2 = client.getCallMap2().get(callId);
                    if (stringeeCall2 != null) {
                        stringeeCall2.setCallStatus(code);
                        stringeeCall2.setState(callState);
                        StringeeCall2.StringeeCallListener callListener = stringeeCall2.getCallListener();
                        if (callListener != null) {
                            callListener.onSignalingStateChange(stringeeCall2, callState, reason, -1, "");
                        }
                        if (code == StringeeConstant.SIP_CODE_OK && stringeeCall2.isCaller()) {
                            // Subscribe remote track
                            StringeeRoom room = stringeeCall2.getRoom();
                            if (room != null) {
                                List<StringeeVideoTrack> videoTracks = room.getRemoteVideoTracks();
                                for (int j = 0; j < videoTracks.size(); j++) {
                                    StringeeVideoTrack videoTrack = videoTracks.get(j);
                                    if (!videoTrack.isPlayer()) {
                                        videoTrack.setListener(new StringeeVideoTrack.Listener() {
                                            @Override
                                            public void onMediaAvailable() {
                                                if (stringeeCall2.getRemoteVideoTrack() == null && videoTrack.getTrackType() == StringeeVideoTrack.TrackType.CAMERA) {
                                                    stringeeCall2.setRemoteVideoTrack(videoTrack);
                                                    if (callListener != null) {
                                                        callListener.onRemoteStream(stringeeCall2);
                                                    }
                                                } else {
                                                    if (callListener != null) {
                                                        callListener.onVideoTrackAdded(videoTrack);
                                                    }
                                                }
                                                if (callListener != null) {
                                                    callListener.onRemoteTrackAdded(stringeeCall2, videoTrack);
                                                }
                                            }

                                            @Override
                                            public void onMediaStateChange(StringeeVideoTrack.MediaState state) {
                                                if (callListener != null) {
                                                    StringeeCall2.MediaState callState;
                                                    if (state == StringeeVideoTrack.MediaState.CONNECTED) {
                                                        callState = StringeeCall2.MediaState.CONNECTED;
                                                    } else {
                                                        callState = StringeeCall2.MediaState.DISCONNECTED;
                                                    }
                                                    callListener.onMediaStateChange(stringeeCall2, callState);
                                                }
                                            }
                                        });
                                        StringeeVideoTrack.Options opts = new StringeeVideoTrack.Options();
                                        opts.audio(true);
                                        opts.video(stringeeCall2.isVideoCall());
                                        room.subscribe(videoTrack, opts, new StatusListener() {
                                            @Override
                                            public void onSuccess() {
                                            }
                                        });
                                    }
                                }
                            }
                        }

                        if (code >= 400) {
                            stringeeCall2.release();
                        }
                    }
                }
            } catch (JSONException e) {
                throw new RuntimeException(e);
            }
        });
    }
}
