package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Utils;
import com.stringee.listener.StringeeRoomListener;
import com.stringee.network.tcpclient.packet.Packet;
import com.stringee.video.RemoteParticipant;
import com.stringee.video.StringeeRoom;
import com.stringee.video.StringeeVideoTrack;
import com.stringee.video.StringeeVideoTrack.MediaType;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

public class VideoRoomEnableDisableVideoNotification extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                String roomId = packet.optFieldString("roomId");
                String userId = packet.getFieldString("actorUserId");
                int mediaType = packet.getFieldInt("mediaType");
                JSONObject jsonObject = packet.optFieldJSONObject("track");
                String trackId = jsonObject.getString("serverId");
                boolean audio = jsonObject.getBoolean("audio");
                boolean video = jsonObject.getBoolean("video");
                boolean screen = jsonObject.getBoolean("screen");

                StringeeRoom room = client.getRoomMap().get(roomId);
                if (room == null) {
                    return;
                }
                RemoteParticipant remoteParticipant = room.getRemoteParticipant(userId);
                if (remoteParticipant != null) {
                    List<StringeeVideoTrack> videoTracks = room.getVideoTracks();
                    if (!Utils.isEmpty(videoTracks)) {
                        for (int i = 0; i < videoTracks.size(); i++) {
                            StringeeVideoTrack videoTrack = videoTracks.get(i);
                            if (videoTrack.getId() != null && videoTrack.getId().equals(trackId)) {
                                videoTrack.setAudio(audio);
                                videoTrack.setVideo(video);
                                videoTrack.setScreenCapture(screen);
                                room.getVideoTrackMap().put(videoTrack.getLocalId(), videoTrack);
                                if (!videoTrack.getUserId().equals(client.getUserId())) {
                                    MediaType type = MediaType.getType(mediaType);
                                    StringeeRoomListener listener = room.getListener();
                                    if (listener != null) {
                                        listener.onVideoTrackNotification(remoteParticipant, videoTrack, type);
                                    }
                                }
                                break;
                            }
                        }
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(VideoRoomEnableDisableVideoNotification.class, e);
            }
        });
    }
}
