package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class VideoRoomEndCall extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                StatusListener listener = Common.statusListenerMap.get(requestId);
                if (listener != null) {
                    if (r == 0) {
                        listener.onSuccess();
                    } else if (r == 1) {
                        listener.onError(new StringeeError(r, "The call is not existence"));
                    } else if (r == 2) {
                        listener.onError(new StringeeError(r, "The call answered on another device"));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(VideoRoomEndCall.class, e);
            }
        });
    }
}
