package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.call.CallType;
import com.stringee.call.StringeeCall2;
import com.stringee.common.Common;
import com.stringee.common.SendPacketUtils;
import com.stringee.common.StringeeConstant;
import com.stringee.common.Utils;
import com.stringee.exception.StringeeError;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class VideoRoomMakeCall extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                StringeeCall2 stringeeCall = client.getCallRequest2().get(requestId);
                if (stringeeCall == null) {
                    return;
                }
                CallbackListener<StringeeCall2> listener = Common.callbackListenerMap.get(requestId);
                if (r == 0) {
                    String callId = packet.optFieldString("callId");
                    if (stringeeCall.getCallStatus() == StringeeConstant.SIP_CODE_ENDED) { // The call is hangup
                        int requestId1;
                        synchronized (Common.lock) {
                            requestId1 = ++Common.requestId;
                        }
                        SendPacketUtils.endCall2(client, requestId1, callId, "Current call is ended");
                        return;
                    }
                    String roomId = packet.getFieldString("roomId");
                    String roomToken = packet.getFieldString("roomToken");
                    stringeeCall.setCallId(callId);
                    stringeeCall.setCallType(CallType.APP_TO_APP_OUTGOING);
                    stringeeCall.setRoomId(roomId);
                    stringeeCall.setRoomToken(roomToken);

                    if (listener != null) {
                        listener.onSuccess(stringeeCall);
                    }
                } else {
                    if (listener != null) {
                        listener.onError(new StringeeError(r, packet.optFieldString("message", "")));
                    }
                }
                client.getCallRequest2().remove(requestId);
            } catch (JSONException e) {
                Utils.reportException(VideoRoomMakeCall.class, e);
            }
        });
    }
}
