package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Utils;
import com.stringee.listener.StringeeRoomListener;
import com.stringee.network.tcpclient.packet.Packet;
import com.stringee.video.RemoteParticipant;
import com.stringee.video.StringeeRoom;
import com.stringee.video.StringeeVideoTrack;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

public class VideoTrackRemoved extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                String roomId = packet.optFieldString("roomId");
                JSONObject jsonObject = packet.optFieldJSONObject("track");
                String trackId = jsonObject.getString("serverId");
                StringeeRoom room = client.getRoomMap().get(roomId);
                if (room == null) {
                    return;
                }
                List<StringeeVideoTrack> videoTracks = room.getVideoTracks();
                if (!Utils.isEmpty(videoTracks)) {
                    for (int i = 0; i < videoTracks.size(); i++) {
                        StringeeVideoTrack videoTrack = videoTracks.get(i);
                        if (videoTrack.getId() != null && videoTrack.getId().equals(trackId)) {
                            room.getVideoTrackMap().remove(trackId);
                            room.getVideoTrackMap().remove(videoTrack.getLocalId());
                            RemoteParticipant remoteParticipant =
                                    room.getRemoteParticipant(videoTrack.getUserId());
                            if (remoteParticipant != null) {
                                remoteParticipant.removeVideoTrack(videoTrack);
                            }
                            videoTrack.release();
                            StringeeRoomListener listener = room.getListener();
                            if (listener != null) {
                                listener.onVideoTrackRemoved(room, videoTrack);
                            }
                            break;
                        }
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(VideoTrackRemoved.class, e);
            }
        });
    }
}
