package com.stringee.network.tcpclient.packet;

import android.os.Build;

import androidx.annotation.NonNull;

import com.stringee.common.Utils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

/**
 * @author Alex
 */

public final class Packet {

    public static final int HEADER_LENGTH = 8;

    /*
      ------------------PACKET--------------------------- -->
     */
    /**
     * 2 bytes
     */
    public static final byte[] MAGIC = "ST".getBytes();

    /**
     * 4 bytes
     */
    private int length = 0;
    /**
     * 2 bytes
     */
    private short service = 0;

    /**
     * Packet DATA
     */
    private byte[] data = new byte[0];
    /**
     * ------------------PACKET--------------------------- <--
     */
    JSONObject jsonData = null;

    private int numberOfResend = 0;
    // private TimerTask timerTask;
    private int msgId;
    private int userId;

    public Packet() {
    }

    public Packet(Packet packet) {
        setService(packet.getService());
        setUserId(packet.getUserId());
    }

    public Packet(ServiceType st) {
        service = st.getValue();
    }

    public Packet(short type) {
        service = type;
    }

    public Packet(int type) {
        service = (short) type;
    }

    public void setJsonData(JSONObject job) {
        this.jsonData = job;
    }

    public JSONObject getJsonData() {
        return jsonData;
    }

    public Object getField(String key) {
        JSONObject json = getJsonData();
        try {
            return json.get(key);
        } catch (JSONException e) {
            Utils.reportException(Packet.class, e);
        }
        return null;
    }

    public void setField(String key, Object value) {
        if (jsonData == null) {
            jsonData = new JSONObject();
        }
        try {
            jsonData.put(key, value);
        } catch (JSONException e) {
            Utils.reportException(Packet.class, e);
        }
    }

    @NonNull
    @Override
    public String toString() {
        String dataString;
        if (jsonData == null) {
            dataString = new String(this.getData());
        } else {
            dataString = jsonData.toString();
        }
        if (ServiceType.getServiceType(this.getService()) != null) {
            return "Service=" + ServiceType.getServiceType(this.getService()) + " | " + "DATA=" + dataString;
        }
        return "Service=" + this.getService() + " (UNKNOW_PACKET) | " + "DATA=" + dataString;
    }

    public byte[] getData() {
        return data;
    }

    public void setData(byte[] data) {
        this.data = data;
        length = data.length;
    }

    public void setLength(int aShort) {
        length = aShort;
    }

    public int getLength() {
        return length;
    }

    public short getService() {
        return service;
    }

    public void setService(short service) {
        this.service = service;
    }

    public void setService(int service) {
        this.service = (short) service;
    }

    public void setService(ServiceType serviceType) {
        this.service = serviceType.getValue();
    }

    public JSONArray optFieldJSONArray(String key) {
        if (jsonData != null) {
            return jsonData.optJSONArray(key);
        }
        return new JSONArray();
    }

    public Integer optFieldInt(String key) {
        if (jsonData != null) {
            return jsonData.optInt(key);
        }
        return 0;
    }

    public Integer optFieldInt(String key, Integer opt) {
        if (jsonData != null) {
            return jsonData.optInt(key, opt);
        }
        return opt;
    }

    public String optFieldString(String key, String opt) {
        if (jsonData != null) {
            return jsonData.optString(key, opt);
        }
        return opt;
    }

    public String optFieldString(String key) {
        if (jsonData != null) {
            return jsonData.optString(key);
        }
        return "";
    }

    public JSONObject optFieldJSONObject(String key) {
        if (jsonData != null) {
            return jsonData.optJSONObject(key);
        }
        return new JSONObject();
    }

    public Double optFieldDouble(String key, Double opt) {
        if (jsonData != null) {
            return jsonData.optDouble(key, opt);
        }
        return opt;
    }

    public Double optFieldDouble(String key) {
        if (jsonData != null) {
            return jsonData.optDouble(key);
        }
        return 0.0;
    }

    public long optFieldLong(String key, long opt) {
        if (jsonData != null) {
            return jsonData.optLong(key, opt);
        }
        return opt;
    }

    public long optFieldLong(String key) {
        if (jsonData != null) {
            return jsonData.optLong(key);
        }
        return 0;
    }

    public boolean optFieldBoolean(String key, boolean opt) {
        if (jsonData != null) {
            return jsonData.optBoolean(key, opt);
        }
        return opt;
    }

    public boolean optFieldBoolean(String key) {
        if (jsonData != null) {
            return jsonData.optBoolean(key);
        }
        return false;
    }

    public void decodeJson() {
        if (length > 0) {
            try {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                    jsonData = new JSONObject(new String(data, StandardCharsets.UTF_8));
                } else {
                    jsonData = new JSONObject(new String(data, "UTF-8"));
                }
            } catch (JSONException | UnsupportedEncodingException ex) {
                try {
                    jsonData = new JSONObject(new String(data));
                } catch (JSONException e) {
                    Utils.reportException(Packet.class, e);
                }
                Utils.reportException(Packet.class, ex);
            }
        }
    }

    public String getFieldString(String key) throws JSONException {
        if (jsonData != null) {
            return jsonData.getString(key);
        }
        return null;
    }

    public Integer getFieldInt(String key) throws JSONException {
        if (jsonData != null) {
            return jsonData.getInt(key);
        }
        return null;
    }

    public boolean getBoolean(String key) throws JSONException {
        if (jsonData != null) {
            return jsonData.getBoolean(key);
        }
        return false;
    }

    public long getFieldLong(String key) throws JSONException {
        if (jsonData != null) {
            return jsonData.getLong(key);
        }
        return 0;
    }

    public void setJsonData(JSONArray jsonArray) {
        data = jsonArray.toString().getBytes();
        length = data.length;
    }

    public int getNumberOfResend() {
        return numberOfResend;
    }

    public void setNumberOfResend(int numberOfResend) {
        this.numberOfResend = numberOfResend;
    }

    public int getMsgId() {
        return msgId;
    }

    public void setMsgId(int msgId) {
        this.msgId = msgId;
    }

    public int getUserId() {
        return userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    private int id;//de luu vao db

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }
}
