package com.stringee.video;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Insets;
import android.media.projection.MediaProjection.Callback;
import android.os.Build.VERSION;
import android.os.Build.VERSION_CODES;
import android.util.DisplayMetrics;
import android.view.WindowInsets.Type;
import android.view.WindowMetrics;

import androidx.annotation.RequiresApi;

import com.stringee.common.Utils;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.video.StringeeVideoTrack.TrackType;

import org.webrtc.ScreenCapturerAndroid;

@RequiresApi(21)
public class StringeeScreenCapture {
    private Intent mediaProjectionPermissionResultData;
    private final Activity activity;
    private final StringeeVideoTrack captureTrack;
    private final VideoDimensions videoDimensions;

    public void reCreateCaptureTrack(CallbackListener<StringeeVideoTrack> listener) {
        createCapture(mediaProjectionPermissionResultData, listener);
    }

    public StringeeVideoTrack getCaptureTrack() {
        return captureTrack;
    }

    public StringeeScreenCapture(Activity activity) {
        this.activity = activity;
        // create track
        captureTrack = new StringeeVideoTrack();
        captureTrack.setLocal(true);
        captureTrack.setAudio(false);
        captureTrack.setVideo(false);
        captureTrack.setScreenCapture(true);
        captureTrack.setTrackType(TrackType.SCREEN);
        String localId = Utils.getDeviceId(activity) + "-" + System.currentTimeMillis();
        captureTrack.setLocalId(localId);

        // Create video dimensions
        if (VERSION.SDK_INT >= VERSION_CODES.R) {
            WindowMetrics windowMetrics = activity.getWindowManager().getCurrentWindowMetrics();
            Insets insets = windowMetrics.getWindowInsets().getInsetsIgnoringVisibility(Type.systemBars());
            videoDimensions = new VideoDimensions(windowMetrics.getBounds().width() - insets.left - insets.right, windowMetrics.getBounds().height() - insets.top - insets.bottom);
        } else {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            activity.getWindowManager().getDefaultDisplay().getRealMetrics(displayMetrics);
            videoDimensions = new VideoDimensions(displayMetrics.widthPixels / 2, displayMetrics.heightPixels / 2);
        }
    }

    public void createCapture(Intent mediaProjectionPermissionResultData, CallbackListener<StringeeVideoTrack> listener) {
        this.mediaProjectionPermissionResultData = mediaProjectionPermissionResultData;
        captureTrack.createCapture(activity, videoDimensions, new ScreenCapturerAndroid(mediaProjectionPermissionResultData, new Callback() {
        }));

        if (listener != null) {
            listener.onSuccess(captureTrack);
        }
    }
}
