package com.stringee.call;

import android.util.Log;

import com.stringee.StringeeClient;

import org.webrtc.DataChannel;
import org.webrtc.IceCandidate;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.RtpReceiver;

import java.util.concurrent.LinkedBlockingQueue;

/**
 * Created by luannguyen on 1/25/16.
 */
public class PCObserver implements PeerConnection.Observer {

    private final StringeeCall stringeeCall;

    public PCObserver(StringeeCall stringeeCall) {
        this.stringeeCall = stringeeCall;
    }

    @Override
    public void onSignalingChange(PeerConnection.SignalingState signalingState) {
        Log.d("Stringee", "+++++++++++++++++++++++ onSignalingChange");
    }

    @Override
    public void onIceConnectionChange(final PeerConnection.IceConnectionState iceConnectionState) {
        Log.d("Stringee", "+++++++++++++++++++++++ onIceConnectionChange " + iceConnectionState.toString());
        StringeeClient client = stringeeCall.getClient();
        client.executeExecutor(() -> {
            StringeeCallFactory callFactory = stringeeCall.getCallFactory();
            if (callFactory != null && callFactory.getListener() != null) {
                StringeeCallFactory.StringeeCallListener.StringeeConnectionState state = StringeeCallFactory.StringeeCallListener.StringeeConnectionState.NEW;
                if (iceConnectionState == PeerConnection.IceConnectionState.CHECKING) {
                    state = StringeeCallFactory.StringeeCallListener.StringeeConnectionState.CHECKING;
                } else if (iceConnectionState == PeerConnection.IceConnectionState.CONNECTED) {
                    state = StringeeCallFactory.StringeeCallListener.StringeeConnectionState.CONNECTED;
                } else if (iceConnectionState == PeerConnection.IceConnectionState.COMPLETED) {
                    state = StringeeCallFactory.StringeeCallListener.StringeeConnectionState.COMPLETED;
                } else if (iceConnectionState == PeerConnection.IceConnectionState.FAILED) {
                    state = StringeeCallFactory.StringeeCallListener.StringeeConnectionState.FAILED;
                } else if (iceConnectionState == PeerConnection.IceConnectionState.DISCONNECTED) {
                    state = StringeeCallFactory.StringeeCallListener.StringeeConnectionState.DISCONNECTED;
                } else if (iceConnectionState == PeerConnection.IceConnectionState.CLOSED) {
                    state = StringeeCallFactory.StringeeCallListener.StringeeConnectionState.CLOSED;
                }

                if (iceConnectionState == PeerConnection.IceConnectionState.CONNECTED) {
                    callFactory.iceConnected = true;
                    String id = stringeeCall.getCallId() + stringeeCall.getDeviceId();
                    LinkedBlockingQueue<StringeeCallData> candidatesQuere = client.getCandidatesMap().get(id);
                    if (candidatesQuere != null) {
                        candidatesQuere.clear();
                    }
                }

                callFactory.getListener().onChangeConnectionState(stringeeCall.getCallId(), state);
            }
        });
    }

    @Override
    public void onIceConnectionReceivingChange(boolean b) {
        Log.d("Stringee", "+++++++++++++++++++++++ onIceConnectionReceivingChange");
    }

    @Override
    public void onIceGatheringChange(PeerConnection.IceGatheringState iceGatheringState) {
        Log.d("Stringee", "+++++++++++++++++++++++ onIceGatheringChange " + iceGatheringState.toString());
    }

    @Override
    public void onIceCandidate(final IceCandidate iceCandidate) {
        Log.d("Stringee", "+++++++++++++++++++++++ onIceCandidate: " + iceCandidate.sdp);
        StringeeClient client = stringeeCall.getClient();
        client.executeExecutor(() -> {
            StringeeCallFactory callFactory = stringeeCall.getCallFactory();
            if (callFactory != null && callFactory.getListener() != null) {
                StringeeIceCandidate ice = new StringeeIceCandidate(iceCandidate.sdpMid, iceCandidate.sdpMLineIndex, iceCandidate.sdp);
                callFactory.getListener().onCreateIceCandidate(ice);
            }
        });
    }

    @Override
    public void onIceCandidatesRemoved(IceCandidate[] iceCandidates) {
        Log.d("Stringee", "+++++++++++++++++++++++ onIceCandidatesRemoved");
    }

    @Override
    public void onAddStream(final MediaStream stream) {
        StringeeClient client = stringeeCall.getClient();
        client.executeExecutor(() -> {
            StringeeCallFactory callFactory = stringeeCall.getCallFactory();
            if (callFactory != null && callFactory.getListener() != null) {
                callFactory.getListener().onAddStream(stream);
            }
        });
    }

    @Override
    public void onRemoveStream(MediaStream mediaStream) {
        Log.d("Stringee", "+++++++++++++++++++++++ onRemoveStream");
    }

    @Override
    public void onDataChannel(DataChannel dataChannel) {
        Log.d("Stringee", "+++++++++++++++++++++++ onDataChannel");
    }

    @Override
    public void onRenegotiationNeeded() {
        Log.d("Stringee", "+++++++++++++++++++++++ onRenegotiationNeeded");
    }

    @Override
    public void onAddTrack(RtpReceiver rtpReceiver, MediaStream[] mediaStreams) {

    }
}
