package com.stringee.common;

public class APIUrlUtils {
    private static APIUrlUtils instance;
    private String baseUrl = "https://api.stringee.com";
    private String baseXUrl = "https://api.stringeex.com";
    private static final String URL_UPLOAD_FILE_URL = "/v1/file/upload?uploadType=multipart";
    private static final String URL_UPLOAD_STATS = "/v1/calltracelog";
    private static final String URL_LIVECHAT_PROFILE = "/v1/chatcustomer/getsettingandqueues?key=";
    private static final String URL_LIVECHAT_CREATE_TOKEN = "/v1/chatcustomer?key=";
    private static final String URL_LIVECHAT_CREATE_TICKET = "/v1/chatcustomer/generateticket?key=";
    private static final String URL_GET_SERVER_ADDRESS = "/v2/getStringeeServerAddress";

    public static APIUrlUtils getInstance() {
        if (instance == null) {
            instance = new APIUrlUtils();
        }
        return instance;
    }

    public void setBaseAPIUrl(String baseUrl) {
        if (!Utils.isEmpty(baseUrl)) {
            this.baseUrl = baseUrl;
        }
    }

    public String getUploadFileUrl() {
        return baseUrl + URL_UPLOAD_FILE_URL;
    }

    public String getUploadStatsUrl() {
        return baseUrl + URL_UPLOAD_STATS;
    }

    public void setStringeeXBaseUrl(String baseXUrl) {
        if (!Utils.isEmpty(baseXUrl)) {
            this.baseXUrl = baseXUrl;
        }
    }

    public String getLiveChatProfileUrl() {
        return baseXUrl + URL_LIVECHAT_PROFILE;
    }

    public String getLiveChatCreateTokenUrl() {
        return baseXUrl + URL_LIVECHAT_CREATE_TOKEN;
    }

    public String getLiveChatCreateTicketUrl() {
        return baseXUrl + URL_LIVECHAT_CREATE_TICKET;
    }

    public String getStringeeServerAddressUrl() {
        return baseUrl + URL_GET_SERVER_ADDRESS;
    }
}
