package com.stringee.common;

import com.stringee.StringeeClient;
import com.stringee.network.tcpclient.packet.Packet;
import com.stringee.network.tcpclient.packet.ServiceType;

import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class GetUserInfo {

    private static final ConcurrentHashMap<String, Queue<Packet>> userInfoMap = new ConcurrentHashMap<>();

    public static void put(StringeeClient client, String userId, Packet packet) {
        Queue<Packet> queue = userInfoMap.get(userId);

        if (queue == null) {
            queue = new LinkedBlockingQueue<>();
            queue.add(packet);
            userInfoMap.put(userId, queue);

            // Get user info from server
            Packet infoPacket = new Packet(ServiceType.GET_USER_INFO);
            infoPacket.setField("userIds", userId);
            if (client.getPacketSenderThread() != null) {
                client.getPacketSenderThread().send(infoPacket);
            }
        } else {
            queue.add(packet);
        }
    }

    public static Queue<Packet> get(String userId) {
        return userInfoMap.get(userId);
    }

    public static void remove(String userId) {
        userInfoMap.remove(userId);
    }
}
