package com.stringee.common;

import android.content.Context;
import android.content.SharedPreferences;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by luannguyen on 2/5/2018.
 */

public class PrefUtils {

    private static volatile PrefUtils prefUtils;
    private static SharedPreferences sharedPreferences;
    private static SharedPreferences.Editor editor;

    public static PrefUtils getInstance(Context context) {
        if (prefUtils == null) {
            synchronized (VolleyUtils.class) {
                if (prefUtils == null) {
                    prefUtils = new PrefUtils();
                    sharedPreferences = context.getSharedPreferences(Constant.PREF_NAME, Context.MODE_PRIVATE);
                    editor = sharedPreferences.edit();
                }
            }
        }
        return prefUtils;
    }

    public String getString(String name) {
        return sharedPreferences.getString(name, null);
    }

    public void putString(String name, String value) {
        editor.putString(name, value);
        editor.commit();
    }

    public void remove(String name) {
        editor.remove(name);
        editor.commit();
    }

    public void savePushToken(String key, String token, String status) {
        String data = null;
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(Constant.TOKEN, token);
            jsonObject.put(Constant.STATUS, status);
            data = jsonObject.toString();
        } catch (JSONException e) {
            Utils.reportException(PrefUtils.class, e);
        }
        editor.putString(key, data);
        editor.commit();
    }

    public void saveUnregisteredToken(String username, String token, String userId, int projectId) {
        String data = sharedPreferences.getString(Constant.PUSH_UNREGISTER, null);
        JSONArray jsonArray = null;
        if (data != null) {
            try {
                jsonArray = new JSONArray(data);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(Constant.TOKEN, token);
                jsonObject.put(Constant.USER_ID, userId);
                jsonObject.put(Constant.PROJECT_ID, projectId);
                jsonObject.put(Constant.USER_NAME, username);
                jsonArray.put(jsonObject);
            } catch (JSONException e) {
                Utils.reportException(PrefUtils.class, e);
            }
        } else {
            jsonArray = new JSONArray();
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put(Constant.TOKEN, token);
                jsonObject.put(Constant.USER_ID, userId);
                jsonObject.put(Constant.PROJECT_ID, projectId);
                jsonObject.put(Constant.USER_NAME, username);
                jsonArray.put(jsonObject);
            } catch (JSONException e) {
                Utils.reportException(PrefUtils.class, e);
            }
        }
        if (jsonArray != null) {
            editor.putString(Constant.PUSH_UNREGISTER, jsonArray.toString());
            editor.commit();
        }
    }

}
