package com.stringee.common;

import android.content.Context;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;

public class VolleyUtils {
    private static volatile VolleyUtils instance;
    private final RequestQueue requestQueue;

    public VolleyUtils(Context context) {
        requestQueue = Volley.newRequestQueue(context.getApplicationContext());
    }

    public static VolleyUtils getInstance(Context context) {
        if (instance == null) {
            synchronized (VolleyUtils.class) {
                if (instance == null) {
                    instance = new VolleyUtils(context.getApplicationContext());
                }
            }
        }
        return instance;
    }

    private RequestQueue getRequestQueue() {
        return requestQueue;
    }

    public <T> Request<T> add(Request<T> request) {
        return getRequestQueue().add(request);
    }
}
