package com.stringee.common.event;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Event {
    private String tag;
    private final Map<String, Object> map = new HashMap<>();

    public Event(@NonNull String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return tag;
    }

    public Event setTag(String tag) {
        this.tag = tag;
        return this;
    }

    public Event put(String key, Object value) {
        map.put(key, value);
        return this;
    }

    public Set<String> keySet() {
        return map.keySet();
    }

    public boolean isEmpty() {
        return map.isEmpty();
    }

    @Nullable
    public <V> V getData(@Nullable String key) {
        final Object o = map.get(key);
        try {
            return (V) o;
        } catch (ClassCastException e) {
            return null;
        }
    }

    public <V> V getData(@Nullable String key, V defaultValue) {
        final V v = getData(key);
        return (v == null) ? defaultValue : v;
    }
}
