package com.stringee.common.event;

public enum EventNotify {
    CLIENT_CONNECTION_CONNECTED(EventConstants.BASE + ".client.connection_connected"),
    CLIENT_CONNECTION_DISCONNECTED(EventConstants.BASE + ".client.connection_disconnected"),
    CLIENT_INCOMING_CALL(EventConstants.BASE + ".client.incoming_call"),
    CLIENT_INCOMING_CALL2(EventConstants.BASE + ".client.incoming_call2"),
    CLIENT_CONNECTION_ERROR(EventConstants.BASE + ".client.connection_error"),
    CLIENT_REQUEST_NEW_TOKEN(EventConstants.BASE + ".client.request_new_token"),
    CLIENT_RECEIVE_CUSTOM_MESSAGE(EventConstants.BASE + ".client.receive_custom_message"),
    CLIENT_RECEIVE_TOPIC_MESSAGE(EventConstants.BASE + ".client.receive_topic_message"),
    CHAT_CONVERSATION_CHANGE(EventConstants.BASE + ".chat.conversation_change"),
    CHAT_MESSAGE_CHANGE(EventConstants.BASE + ".chat.message_change"),
    CHAT_USER_TYPING(EventConstants.BASE + ".chat.user_typing"),
    CHAT_USER_END_TYPING(EventConstants.BASE + ".chat.user_end_typing"),
    CHAT_SUPPORT_RECEIVE_CHAT_REQUEST(EventConstants.BASE + ".chat_support.receive_chat_request"),
    CHAT_SUPPORT_REQUEST_HANDLE_ON_ANOTHER_DEVICE(EventConstants.BASE + ".chat_support.request_handle_on_another_device"),
    CHAT_SUPPORT_TIMEOUT_ANSWER(EventConstants.BASE + ".chat_support.timeout_answer"),
    CHAT_SUPPORT_TIMEOUT_IN_QUEUE(EventConstants.BASE + ".chat_support.timeout_in_queue"),
    CHAT_SUPPORT_CONVERSATION_ENDED(EventConstants.BASE + ".chat_support.conversation_ended");

    private final String value;

    EventNotify(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }
}