package com.stringee.database;

public class ConversationConstant {
    public static final String TABLE_NAME = "conversations";
    public static final String ID = "id";
    public static final String LOCAL_ID = "local_id";
    public static final String CONVERSATION_ID = "conversation_id";
    public static final String NAME = "name";
    public static final String IS_GROUP = "is_group";
    public static final String IS_DISTINCT = "is_distinct";
    public static final String USER_ID = "user_id";
    public static final String LAST_UPDATE_TIME = "last_update_time";
    public static final String LAST_MESSAGE_TEXT = "last_message_text";
    public static final String LAST_SENDER_ID = "last_sender_id";
    public static final String LAST_MESSAGE_TYPE = "last_message_type";
    public static final String TOTAL_UNREAD = "total_unread";
    public static final String CREATOR = "creator";
    public static final String LAST_TIME_NEW_MESSAGE = "last_time_new_message";
    public static final String LAST_MESSAGE_STATE = "last_message_state";
    public static final String TYPE = "type";
    public static final String STATE = "state";
    public static final String LAST_SEQUENCE = "last_sequence";
    public static final String LAST_MESSAGE_ID = "last_message_id";
    public static final String CREATED_AT = "created_at";
    public static final String LAST_MESSAGE = "last_message";
    public static final String LAST_MSG_SEQ_RECEIVED = "last_msg_seq_received";
    public static final String PINNED_MSG_ID = "pinned_msg_id";
    public static final String CHANNEL_TYPE = "channel_type";
    public static final String ENDED = "ended";
    public static final String OA_ID = "oa_id";
    public static final String CUSTOM_DATA = "custom_data";
    public static final String LAST_SENDER_NAME = "last_sender_name";
    public static final String LAST_SENDER_AVATAR = "last_sender_avatar";
    public static final String LAST_MSG_SEQ_SEEN = "last_msg_seq_seen";
    public static final String CHAT_STATUS = "chat_status";

    public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS " +
            TABLE_NAME + " (" +
            ID + " INTEGER PRIMARY KEY," +
            LOCAL_ID + " TEXT," +
            CONVERSATION_ID + " TEXT," +
            NAME + " TEXT," +
            IS_GROUP + " INTEGER DEFAULT 0," +
            IS_DISTINCT + " INTEGER DEFAULT 0," +
            USER_ID + " TEXT," +
            LAST_UPDATE_TIME + " INTEGER," +
            LAST_MESSAGE_TEXT + " TEXT," +
            LAST_SENDER_ID + " TEXT," +
            LAST_MESSAGE_TYPE + " INTEGER," +
            TOTAL_UNREAD + " INTEGER," +
            CREATOR + " TEXT," +
            LAST_TIME_NEW_MESSAGE + " INTEGER," +
            LAST_MESSAGE_STATE + " INTEGER," +
            TYPE + " INTEGER," +
            STATE + " INTEGER," +
            LAST_SEQUENCE + " INTEGER," +
            LAST_MESSAGE_ID + " TEXT," +
            CREATED_AT + " INTEGER," +
            LAST_MESSAGE + " TEXT," +
            LAST_MSG_SEQ_RECEIVED + " INTEGER," +
            PINNED_MSG_ID + " TEXT, " +
            CHANNEL_TYPE + " INTEGER," +
            ENDED + " INTEGER DEFAULT 0, " +
            OA_ID + " TEXT, " +
            CUSTOM_DATA + " TEXT, " +
            LAST_SENDER_NAME + " TEXT, " +
            LAST_SENDER_AVATAR + " TEXT, " +
            LAST_MSG_SEQ_SEEN + " INTEGER, " +
            CHAT_STATUS + " INTEGER, " +
            "UNIQUE(" + CONVERSATION_ID + "," + USER_ID + "))";

    public static final String CREATE_CONVERSATION_INDEX = "CREATE INDEX conv_id_index ON " + TABLE_NAME + "("
            + CONVERSATION_ID + ")";
}
