package com.stringee.database;

public class ParticipantConstant {

    public static final String TABLE_NAME = "participants";
    public static final String ID = "id";
    public static final String CONVERSATION_ID = "conversation_id";
    public static final String USER_ID = "user_id";
    public static final String LAST_MSG_RECEIVED_SEQ = "last_msg_received_seq";
    public static final String LAST_MSG_SEEN_SEQ = "last_msg_seen_seq";
    public static final String ROLE = "role";

    public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS " +
            TABLE_NAME + " (" +
            ID + " INTEGER PRIMARY KEY," +
            CONVERSATION_ID + " TEXT," +
            USER_ID + " TEXT," +
            LAST_MSG_RECEIVED_SEQ + " INTEGER," +
            LAST_MSG_SEEN_SEQ + " INTEGER," +
            ROLE + " TEXT)";

    public static final String CREATE_CONVERSATION_INDEX = "CREATE INDEX par_conv_id_index ON " + TABLE_NAME + "("
            + CONVERSATION_ID + ")";
}
