package com.stringee.messaging;

public enum ChatStatus {
    RINGING(0),
    ANSWERING(1),
    ENDED(2),
    MISSED(3),
    INACTIVE(4);

    private final short value;

    ChatStatus(final int value) {
        this.value = (short) value;
    }

    public short getValue() {
        return value;
    }

    public static ChatStatus getStatus(int value) {
        switch (value) {
            case 1:
                return ANSWERING;
            case 2:
                return ENDED;
            case 3:
                return MISSED;
            case 4:
                return INACTIVE;
            default:
                return RINGING;
        }
    }
}
