package com.stringee.messaging;

import java.util.ArrayList;
import java.util.List;

public class ConversationFilter {

    public enum ConversationFilterChatSupportStatus {
        CURRENT_CHAT(0),
        PAST_CHAT(1),
        ALL(2);

        private final short value;

        ConversationFilterChatSupportStatus(final int value) {
            this.value = (short) value;
        }

        public short getValue() {
            return value;
        }

        public static ConversationFilterChatSupportStatus getStats(int value) {
            switch (value) {
                case 0:
                    return CURRENT_CHAT;
                case 1:
                    return PAST_CHAT;
                case 2:
                default:
                    return ALL;
            }
        }
    }

    private ConversationFilterChatSupportStatus filterChatStatus;
    private String oaId;
    private boolean isDeleted = false;
    private boolean isUnread = false;
    private List<ChannelType> channelTypes = new ArrayList<>();

    public ConversationFilter() {
        channelTypes.add(ChannelType.NORMAL);
    }

    public ConversationFilterChatSupportStatus getFilterChatStatus() {
        return filterChatStatus;
    }

    public void setFilterChatStatus(ConversationFilterChatSupportStatus filterChatStatus) {
        this.filterChatStatus = filterChatStatus;
    }

    public String getOaId() {
        return oaId;
    }

    public void setOaId(String oaId) {
        this.oaId = oaId;
    }

    public boolean isDeleted() {
        return isDeleted;
    }

    public void setDeleted(boolean deleted) {
        isDeleted = deleted;
    }

    public boolean isUnread() {
        return isUnread;
    }

    public void setUnread(boolean unread) {
        isUnread = unread;
    }

    public List<ChannelType> getChannelTypes() {
        return channelTypes;
    }

    public void setChannelTypes(List<ChannelType> channelTypes) {
        this.channelTypes = channelTypes;
    }
}
