package com.stringee.messaging;

import java.io.Serializable;

public class StringeeChange implements Serializable {

    public enum Type {
        INSERT(0),
        UPDATE(1),
        DELETE(2);

        private final short value;

        Type(final int value) {
            this.value = (short) value;
        }

        public short getValue() {
            return value;
        }
    }

    private Type changeType;
    private StringeeObject.Type objectType;
    private StringeeObject object;

    public StringeeChange(Type changeType, StringeeObject object) {
        this.changeType = changeType;
        this.object = object;
        objectType = StringeeObject.Type.fromObject(object);
    }

    public Type getChangeType() {
        return changeType;
    }

    public void setChangeType(Type changeType) {
        this.changeType = changeType;
    }

    public StringeeObject.Type getObjectType() {
        return objectType;
    }

    public void setObjectType(StringeeObject.Type objectType) {
        this.objectType = objectType;
    }

    public StringeeObject getObject() {
        return object;
    }

    public void setObject(StringeeObject object) {
        this.object = object;
    }
}
