package com.stringee.messaging;

public abstract class StringeeObject {
    public enum Type {
        CONVERSATION(0),
        MESSAGE(1);

        private final short value;

        Type(final int value) {
            this.value = (short) value;
        }

        public short getValue() {
            return value;
        }

        public static Type fromObject(StringeeObject object) {
            if (object instanceof Conversation) {
                return CONVERSATION;
            } else if (object instanceof Message) {
                return MESSAGE;
            } else {
                throw new IllegalArgumentException("Invalid object type: " + object.getClass());
            }
        }
    }
}
