package com.stringee.messaging;

import java.io.Serializable;

public class User implements Serializable {
    private String userId;
    private String name;
    private String avatarUrl;
    private Role role = Role.MEMBER;
    private String email;
    private String phone;
    private String location;
    private String browser;
    private String platform;
    private String device;
    private String ipAddress;
    private String hostName;
    private String userAgent;
    private long lastMsgSeqReceived;
    private long lastMsgSeqSeen;

    public enum Role {
        ADMIN("admin"),
        MEMBER("member");

        private final String value;

        Role(final String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        public static Role getRole(String value) {
            if (value.equals("admin")) {
                return ADMIN;
            }
            return MEMBER;
        }
    }

    public User() {
    }

    public User(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAvatarUrl() {
        return avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public Role getRole() {
        return role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getBrowser() {
        return browser;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getDevice() {
        return device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getIpAddress() {
        return ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getHostName() {
        return hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public long getLastMsgSeqReceived() {
        return lastMsgSeqReceived;
    }

    public void setLastMsgSeqReceived(long lastMsgSeqReceived) {
        this.lastMsgSeqReceived = lastMsgSeqReceived;
    }

    public long getLastMsgSeqSeen() {
        return lastMsgSeqSeen;
    }

    public void setLastMsgSeqSeen(long lastMsgSeqSeen) {
        this.lastMsgSeqSeen = lastMsgSeqSeen;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof User) {
            User user = (User) object;
            if (userId != null && user.getUserId() != null) {
                return userId.equals(user.getUserId());
            }
        }
        return false;
    }
}
