package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.call.CallType;
import com.stringee.call.StringeeCall;
import com.stringee.call.StringeeCallData;
import com.stringee.common.StringeeConstant;
import com.stringee.common.Utils;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by luannguyen on 7/20/2017.
 */

public class CallSdpCandidateFromServer extends ProcessorBase {

    @Override
    public void process(final StringeeClient client, final Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                final String callId = packet.optFieldString("callId");
                final String deviceId = packet.optFieldString("deviceId", "");
                ConcurrentHashMap<String, StringeeCall> callMap = client.getCallMap();
                final StringeeCall stringeeCall = callMap.get(callId);
                if (stringeeCall == null) {
                    return;
                }

                if (stringeeCall.isAnsweredOnAnotherDevice()) {
                    return;
                }

                String type = packet.optFieldString("type");
                String data = packet.optFieldString("data");
                final StringeeCallData stringeeCallData = new StringeeCallData(type, data);
                if (!stringeeCall.isCaller()) {
                    stringeeCall.setDeviceId(deviceId);
                }
                boolean isUpgradeVideo = false;
                if (stringeeCall.getCallStatus() == StringeeConstant.ICE_CONNECTED && !stringeeCall.isVideoCall()) {
                    // Check video call by SDP
                    if (type.equals("sdp")) {
                        JSONObject jsonObject = new JSONObject(data);
                        String sdp = jsonObject.getString("sdp");
                        String[] lines = sdp.split("\r\n");
                        for (String line : lines) {
                            if (line != null && line.contains("a=group:BUNDLE")) {
                                if (line.contains("video")) {
                                    isUpgradeVideo = true;
                                    stringeeCall.setVideoCall(true);
                                    break;
                                }
                                break;
                            }
                        }
                    }
                }

                String id = callId + deviceId;
                int callStatus = stringeeCall.getCallStatus();
                JSONObject dataObject = new JSONObject(stringeeCallData.getData());
                if (stringeeCallData.getType().equalsIgnoreCase("sdp")) {
                    if (isUpgradeVideo) {
                        stringeeCall.setLocalSdpSet(false);
                        stringeeCall.setRemoteSdpSet(false);
                        stringeeCall.getCallFactory().upgradeVideo(false, false);
                        stringeeCall.getCallFactory().processSdp(stringeeCall, dataObject);
                    } else {
                        if (stringeeCall.getCallType() == CallType.APP_TO_PHONE) {
                            stringeeCall.getCallFactory().processSdp(stringeeCall, dataObject);
                        } else if (stringeeCall.getCallType() == CallType.PHONE_TO_APP) {
                            if (callStatus == StringeeConstant.SIP_CODE_OK || callStatus == StringeeConstant.ICE_CONNECTED) { // if answered, process sdp
                                stringeeCall.getCallFactory().processSdp(stringeeCall, dataObject);
                            } else {
                                client.addCallDataToQueue(id, stringeeCallData);
                            }
                        } else {
                            if (stringeeCall.isCaller()) {
                                if ((callStatus == StringeeConstant.SIP_CODE_OK || callStatus == StringeeConstant.ICE_CONNECTED) && stringeeCall.getDeviceId() != null && stringeeCall.getDeviceId().equals(deviceId)) {
                                    stringeeCall.getCallFactory().processSdp(stringeeCall, dataObject);
                                } else {
                                    client.addCallDataToQueue(id, stringeeCallData);
                                }
                            } else {
                                if (stringeeCall.isInitComplete()) {
                                    stringeeCall.getCallFactory().processSdp(stringeeCall, dataObject);
                                } else {
                                    client.addCallDataToQueue(id, stringeeCallData);
                                }
                            }
                        }
                    }
                } else {
                    if (callStatus == StringeeConstant.ICE_CONNECTED) {
                        return;
                    }
                    if (callStatus == StringeeConstant.SIP_CODE_OK && stringeeCall.isLocalSdpSet() && stringeeCall.isRemoteSdpSet()) {
                        stringeeCall.getCallFactory().processCandidate(dataObject);
                    } else {
                        client.addCallDataToQueue(id, stringeeCallData);
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(CallSdpCandidateFromServer.class, e);
            }
        });
    }
}
