package com.stringee.network.processor;

import android.util.Log;

import com.stringee.StringeeClient;
import com.stringee.call.CallType;
import com.stringee.call.StringeeCall;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by luannguyen on 8/31/2017.
 */

public class CallStartFromServer extends ProcessorBase {

    @Override
    public void process(final StringeeClient client, final Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                String callId = packet.optFieldString("callId");
                StringeeCall call = client.getCallMap().get(callId);
                if (call != null) {
                    Log.d("Stringee", "StringeeCall exists");
                    return;
                }
                boolean isP2P = packet.optFieldBoolean("peerToPeerCall", false);
                String from = packet.getFieldString("fromNumber");
                String to = packet.getFieldString("toNumber");
                boolean fromInternal = packet.getBoolean("fromInternal");
                boolean video = packet.optFieldBoolean("video", false);
                String fromAlias = packet.optFieldString("fromAlias", "");
                String toAlias = packet.optFieldString("toAlias", "");
                String customDataFromYourServer = packet.optFieldString("customDataFromYourServer", "");
                JSONObject encryptPhoneObj = packet.optFieldJSONObject("encryptPhone");
                String encryptPhone = "";
                if (encryptPhoneObj != null) {
                    encryptPhone = encryptPhoneObj.optString("from", "");
                }

                boolean isPhoneToApp = !fromInternal;
                final StringeeCall stringeeCall = new StringeeCall(client, callId, from, to);
                stringeeCall.setCallType(isPhoneToApp ? CallType.PHONE_TO_APP : CallType.APP_TO_APP_INCOMING);
                stringeeCall.setVideoCall(video);
                stringeeCall.setFromAlias(fromAlias);
                stringeeCall.setToAlias(toAlias);
                stringeeCall.setCaller(false);
                stringeeCall.setCustomDataFromYourServer(customDataFromYourServer);
                stringeeCall.setP2P(isP2P);
                stringeeCall.setEncryptNumber(encryptPhone);

                // Add incoming call packet to queue
                ConcurrentHashMap<String, Packet> callInPacket = client.getCallInPacket();
                callInPacket.put(callId, packet);
                EventManager.sendClientIncomingCallEvent(client, stringeeCall);
            } catch (JSONException e) {
                Utils.reportException(CallStartFromServer.class, e);
            }
        });
    }
}
