package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.call.StringeeCall;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.listener.StatusListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

/**
 * Created by luannguyen on 2/8/2018.
 */

public class CallState extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                String callId = packet.optFieldString("callId");
                if (r == 0) {
                    int requestId = packet.getFieldInt("requestId");
                    StatusListener listener = Common.statusListenerMap.get(requestId);
                    if (listener != null) {
                        listener.onSuccess();
                    }
                } else if (r == 2 || r == 1) {
                    final StringeeCall stringeeCall = client.getCallMap().get(callId);
                    if (stringeeCall != null) {
                        String error;
                        if (r == 1) {
                            error = "This call does not exist on Stringee server.";
                        } else {
                            error = "This call is answered from another device.";
                        }

                        StringeeCall.StringeeCallListener callStateListener = stringeeCall.getCallListener();
                        if (callStateListener != null) {
                            callStateListener.onError(stringeeCall, -r, error);
                        }
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(CallState.class, e);
            }
        });
    }
}
