package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.database.DBHandler;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.Message;
import com.stringee.messaging.StringeeChange;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.messaging.listeners.ChangeEventListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

import java.util.List;

public class ChatMessage extends ProcessorBase {
    @Override
    public void process(final StringeeClient client, final Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                String convId = packet.getFieldString("convId");
                String localId = packet.getFieldString("localDbId");
                StatusListener statusListener = Common.statusListenerMap.get(requestId);
                List<ChangeEventListener> changeEventListeners = client.getChangeEventListeners();
                Message message = client.getMessagesMap().get(requestId);
                if (r == 0) {
                    if (statusListener != null) {
                        statusListener.onSuccess();
                    }
                    client.getConversationFromServer(convId, new CallbackListener<Conversation>() {
                        @Override
                        public void onSuccess(Conversation conversation) {
                            EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.UPDATE, conversation));
                        }
                    });

                    String msgId = packet.getFieldString("msgId");
                    int seq = packet.optFieldInt("seq");
                    long created = packet.getFieldLong("created");

                    if (message == null) {
                        return;
                    }

                    message.setConversationId(convId);
                    message.setLocalId(localId);
                    message.setId(msgId);
                    message.setCreatedAt(created);
                    message.setUpdateAt(created);
                    message.setSequence(seq);
                    message.setState(Message.State.SENT);

                    EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.UPDATE, message));
                    client.executeDbExecutor(() -> {
                        // Update message from db
                        DBHandler.getInstance(client.getContext()).updateMessageByLocalId(message);
                    });
                } else {
                    if (statusListener != null) {
                        statusListener.onError(new StringeeError(r, "Failed to send a message"));
                    }

                    if (message == null) {
                        return;
                    }
                    client.executeDbExecutor(() -> {
                        // Delete message from db
                        DBHandler.getInstance(client.getContext()).deleteLocalMessages(convId, client.getUserId(), new String[]{message.getLocalId()});
                    });
                    EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.DELETE, message));
                }
                client.getMessagesMap().remove(requestId);
            } catch (JSONException e) {
                Utils.reportException(ChatMessage.class, e);
            }
        });
    }
}
