package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Constant;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.database.DBHandler;
import com.stringee.messaging.Message;
import com.stringee.messaging.Message.MsgType;
import com.stringee.messaging.StringeeChange;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class ChatMessageReportFromServer extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                String convId = packet.getFieldString("convId");
                int state = packet.getFieldInt("status");
                long lastMsgSeq = packet.getFieldLong("lastMsgSeq");
                String from = packet.getFieldString("from");

                DBHandler dbHandler = DBHandler.getInstance(client.getContext());
                Message localMessage = dbHandler.getMessageBySequence(convId, client.getUserId(), lastMsgSeq);
                if (localMessage != null) {
                    Message.State newState = Message.State.INITIALIZE;
                    switch (state) {
                        case Constant.MESSAGE_STATE_DELIVERED:
                            newState = Message.State.DELIVERED;
                            break;
                        case Constant.MESSAGE_STATE_READ:
                            newState = Message.State.READ;
                            break;
                    }
                    if (newState.getValue() > localMessage.getState().getValue()) {
                        localMessage.setState(newState);
                        EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.UPDATE, localMessage));
                    }
                }

                client.executeDbExecutor(() -> {
                    dbHandler.updateMessagesState(state, lastMsgSeq, convId, client.getUserId(), MsgType.SEND.getValue());
                    // Update last msg received, read
                    if (dbHandler.isParticipantExist(convId, from)) {
                        if (state == 1) {
                            dbHandler.updateLastMsgReceived(convId, from, lastMsgSeq);
                        } else if (state == 2) {
                            dbHandler.updateLastMsgSeen(convId, from, lastMsgSeq);
                        }
                    }
                });
            } catch (JSONException e) {
                Utils.reportException(ChatMessageReportFromServer.class, e);
            }
        });
    }
}
