package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.event.EventManager;
import com.stringee.messaging.ChatRequest;
import com.stringee.network.tcpclient.packet.Packet;

public class ChatRequestTimeoutToAgent extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            String convId = packet.optFieldString("convId");
            ChatRequest chatRequest = client.getChatRequestMap().get(convId);
            if (chatRequest != null) {
                chatRequest.setTimeout(true);
                client.getChatRequestMap().put(convId, chatRequest);
                EventManager.sendChatSupportTimeoutAnswerEvent(client, chatRequest);
            }
        });
    }
}
