package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.messaging.ChannelType;
import com.stringee.messaging.ChatRequest;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class ChatRouteToAgent extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                String convId = packet.getFieldString("convId");
                if (!Utils.isEmpty(convId)) {
                    String customerId = packet.optFieldString("customerId");
                    String name = packet.optFieldString("customerName");
                    ChannelType channelType = ChannelType.getType(packet.optFieldInt("channelType"));

                    ChatRequest chatRequest = new ChatRequest();
                    chatRequest.setConvId(convId);
                    chatRequest.setCustomerId(customerId);
                    chatRequest.setUserId(client.getUserId());
                    chatRequest.setName(name);
                    chatRequest.setChannelType(channelType);

                    client.getChatRequestMap().put(convId, chatRequest);
                    EventManager.sendChatSupportReceiceEvent(client, chatRequest);
                }
            } catch (JSONException e) {
                Utils.reportException(ChatRouteToAgent.class, e);
            }
        });
    }
}
