package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.database.DBHandler;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.messaging.ChatStatus;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.User;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class EndChat extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                StatusListener statusListener = Common.statusListenerMap.get(requestId);
                if (r == 0) {
                    if (statusListener != null) {
                        statusListener.onSuccess();
                    }
                    String convId = packet.getFieldString("convId");
                    String endedBy = packet.optFieldString("endedby");
                    DBHandler dbHandler = DBHandler.getInstance(client.getContext());
                    Conversation conversation = dbHandler.getConversationByRemoteId(convId, client.getUserId());
                    if (conversation != null) {
                        if (!conversation.isEnded()) {
                            conversation.setEnded(true);
                            conversation.setChatStatus(ChatStatus.ENDED);
                            client.executeDbExecutor(() -> dbHandler.updateConversation(conversation));
                            User user;
                            if (Utils.isEmpty(endedBy)) {
                                user = dbHandler.getUser(client.getUserId());
                            } else {
                                user = dbHandler.getUser(endedBy);
                            }
                            EventManager.sendChatSupportHandledEvent(client, conversation, user);
                        }
                    }
                } else {
                    if (statusListener != null) {
                        statusListener.onError(new StringeeError(r, packet.optFieldString("message", "")));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(EndChat.class, e);
            }
        });
    }
}
