package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.exception.StringeeError;
import com.stringee.messaging.Message;
import com.stringee.messaging.Message.MsgType;
import com.stringee.messaging.Message.State;
import com.stringee.messaging.Message.Type;
import com.stringee.messaging.User;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class GetMessages extends ProcessorBase {

    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                CallbackListener<List<Message>> listener = Common.callbackListenerMap.get(requestId);
                if (r == 0) {
                    JSONArray jsonArray = packet.optFieldJSONArray("listMsgs");
                    if (!Utils.isEmpty(jsonArray)) {
                        List<Message> lstMessages = new ArrayList<>();
                        for (int i = 0; i < jsonArray.length(); i++) {
                            JSONObject jsonObject = jsonArray.getJSONObject(i);
                            String convId = jsonObject.optString("convId");
                            String localId = jsonObject.optString("localDbId");
                            String msgId = jsonObject.optString("id");
                            long createdTime = jsonObject.optLong("created");
                            String from = jsonObject.optString("user");
                            long seq = jsonObject.optLong("seq");
                            String text;
                            double latitude = 0;
                            double longitude = 0;
                            String fileUrl = "";
                            String fileName = "";
                            long fileLength = 0;
                            String fileId = "";
                            String thumbnailUrl = "";
                            int duration = 0;
                            float ratio = 0;
                            String stickerName = "";
                            String stickerCategory = "";
                            String contact = "";
                            boolean isDeleted;
                            JSONObject messageObject = jsonObject.optJSONObject("content");
                            if (messageObject != null) {
                                text = messageObject.optString("content", "");
                                Type type = Type.getType(jsonObject.optInt("type"));
                                switch (type) {
                                    case RENAME_CONVERSATION:
                                    case CREATE_CONVERSATION:
                                    case RATING:
                                    case NOTIFICATION:
                                        text = messageObject.toString();
                                        break;
                                    case LOCATION:
                                        JSONObject locationObject = messageObject.optJSONObject("location");
                                        if (locationObject != null) {
                                            latitude = locationObject.optDouble("lat");
                                            longitude = locationObject.optDouble("lon");
                                        }
                                        break;
                                    case CONTACT:
                                        JSONObject contactObject = messageObject.optJSONObject("contact");
                                        if (contactObject != null) {
                                            contact = contactObject.optString("vcard");
                                        }
                                        break;
                                    case PHOTO:
                                        JSONObject photoObject = messageObject.optJSONObject("photo");
                                        if (photoObject != null) {
                                            ratio = (float) photoObject.optDouble("ratio");
                                            fileUrl = photoObject.optString("filePath");
                                            thumbnailUrl = photoObject.optString("thumbnail");
                                            fileId = photoObject.optString("file_id");
                                        }
                                        break;
                                    case VIDEO:
                                        JSONObject videoObject = messageObject.optJSONObject("video");
                                        if (videoObject != null) {
                                            ratio = (float) videoObject.optDouble("ratio");
                                            fileUrl = videoObject.optString("filePath");
                                            duration = videoObject.optInt("duration");
                                            thumbnailUrl = videoObject.optString("thumbnail");
                                            fileId = videoObject.optString("file_id");
                                            fileName = videoObject.optString("filename");
                                        }
                                        break;
                                    case AUDIO:
                                        JSONObject audioObject = messageObject.optJSONObject("audio");
                                        if (audioObject != null) {
                                            fileUrl = audioObject.optString("filePath");
                                            duration = audioObject.optInt("duration");
                                            fileId = audioObject.optString("file_id");
                                            fileName = audioObject.optString("filename");
                                        }
                                        break;
                                    case FILE:
                                        JSONObject fileObject = messageObject.optJSONObject("file");
                                        if (fileObject != null) {
                                            fileUrl = fileObject.optString("filePath");
                                            fileName = fileObject.optString("filename");
                                            fileLength = fileObject.optLong("length");
                                            fileId = fileObject.optString("file_id");
                                        }
                                        break;
                                    case STICKER:
                                        JSONObject stickerObject = messageObject.optJSONObject("sticker");
                                        if (stickerObject != null) {
                                            stickerCategory = stickerObject.optString("category");
                                            stickerName = stickerObject.optString("name");
                                        }
                                        break;
                                }

                                int deletedStatus = packet.optFieldInt("deletedStatus", 0);
                                isDeleted = deletedStatus != 0;

                                Message message = new Message();
                                message.setConversationId(convId);
                                message.setLocalId(localId);
                                message.setId(msgId);
                                message.setCreatedAt(createdTime);
                                User sender = new User(from);
                                JSONObject senderInfoObject = jsonObject.optJSONObject("senderInfo");
                                if (senderInfoObject != null) {
                                    if (senderInfoObject.has("display_name")) {
                                        String displayName = senderInfoObject.getString("display_name");
                                        sender.setName(displayName);
                                    }
                                    if (senderInfoObject.has("avatar_url")) {
                                        String avatarUrl = senderInfoObject.optString("avatar_url");
                                        sender.setName(avatarUrl);
                                    }
                                }
                                message.setSender(sender);
                                message.setSequence(seq);
                                message.setText(text);
                                message.setType(type);
                                message.setLatitude(latitude);
                                message.setLongitude(longitude);
                                message.setFileUrl(fileUrl);
                                message.setThumbnailUrl(thumbnailUrl);
                                message.setDuration(duration);
                                message.setImageRatio(ratio);
                                message.setContact(contact);
                                message.setFileName(fileName);
                                message.setFileLength(fileLength);
                                message.setFileId(fileId);
                                message.setClientId(client.getUserId());
                                message.setStickerCategory(stickerCategory);
                                message.setStickerName(stickerName);
                                if (from.equals(client.getUserId())) {
                                    message.setMsgType(MsgType.SEND);
                                    message.setState(State.SENT);
                                } else {
                                    message.setMsgType(MsgType.RECEIVE);
                                    message.setState(State.DELIVERED);
                                }

                                JSONObject customObject = messageObject.optJSONObject("metadata");
                                if (customObject != null) {
                                    message.setCustomData(customObject);
                                }
                                message.setDeleted(isDeleted);

                                lstMessages.add(message);
                            }
                        }

                        if (listener != null) {
                            listener.onSuccess(lstMessages);
                        }
                    } else {
                        if (listener != null) {
                            listener.onError(new StringeeError(-100, "No message found."));
                        }
                    }
                } else {
                    if (listener != null) {
                        listener.onError(new StringeeError(r, packet.optFieldString("message", "Error")));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(GetMessages.class, e);
            }
        });
    }
}
