package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.network.tcpclient.packet.Packet;
import com.stringee.network.tcpclient.packet.ServiceType;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Alex
 */

public abstract class ProcessorBase {

    private static class ProcessorHolder {
        static final Map<Short, ProcessorBase> ALL_PROCESSORS = new HashMap<>();

        static {
            ALL_PROCESSORS.put(ServiceType.PING.getValue(), new Ping());
            ALL_PROCESSORS.put(ServiceType.AUTHEN.getValue(), new Authenticate());

            // Peer-to-peer call
            ALL_PROCESSORS.put(ServiceType.CALL_START.getValue(), new CallStart());
            ALL_PROCESSORS.put(ServiceType.CALL_STATE_FROM_SERVER.getValue(), new CallStateChange());
            ALL_PROCESSORS.put(ServiceType.CALL_SDP_CANDIDATE_FROM_SERVER.getValue(), new CallSdpCandidateFromServer());
            ALL_PROCESSORS.put(ServiceType.CALL_STOP.getValue(), new CallStop());
            ALL_PROCESSORS.put(ServiceType.CALL_STOP_FROM_SERVER.getValue(), new CallStopFromServer());
            ALL_PROCESSORS.put(ServiceType.CALL_START_FROM_SERVER.getValue(), new CallStartFromServer());
            ALL_PROCESSORS.put(ServiceType.CALL_DTMF.getValue(), new CallDTMF());
            ALL_PROCESSORS.put(ServiceType.CALL_DTMF2.getValue(), new CallDTMF());
            ALL_PROCESSORS.put(ServiceType.CALL_INFO.getValue(), new CallInfo());
            ALL_PROCESSORS.put(ServiceType.CALL_INFO_FROM_SERVER.getValue(), new CallInfoFromServer());
            ALL_PROCESSORS.put(ServiceType.MSG_FROM_OTHER_DEVICE.getValue(), new MsgFromOtherDevice());
            ALL_PROCESSORS.put(ServiceType.PUSH_DEVICE_TOKEN_REGISTER.getValue(), new RegisterPushToken());
            ALL_PROCESSORS.put(ServiceType.PUSH_DEVICE_TOKEN_UNREGISTER.getValue(), new UnregisterPushToken());
            ALL_PROCESSORS.put(ServiceType.CALL_STATE.getValue(), new CallState());
            ALL_PROCESSORS.put(ServiceType.CUSTOM_MESSAGE.getValue(), new SendCustomMessage());
            ALL_PROCESSORS.put(ServiceType.CUSTOM_MESSAGE_FROM_SERVER.getValue(), new CustomMessageFromServer());
            ALL_PROCESSORS.put(ServiceType.TRANSFER_CALL.getValue(), new TransferCall());
            ALL_PROCESSORS.put(ServiceType.CHANGE_ATTRIBUTE.getValue(), new ChangeAttribute());
            ALL_PROCESSORS.put(ServiceType.SUBSCRIBE_FROM_SERVER.getValue(), new SubscribeFromServer());
            ALL_PROCESSORS.put(ServiceType.CALL_SDP_CANDIDATE.getValue(), new SdpCandidate());
            ALL_PROCESSORS.put(ServiceType.HOLD.getValue(), new HoldUnhold());

            // Conference
            ALL_PROCESSORS.put(ServiceType.VIDEO_ENDPOINT_JOIN_ROOM.getValue(), new ConnectRoom());
            ALL_PROCESSORS.put(ServiceType.VIDEO_PUBLISH_TRACK.getValue(), new PublishVideoTrack());
            ALL_PROCESSORS.put(ServiceType.VIDEO_ENDPOINT_SDP_FROM_SERVER.getValue(), new VideoSDPFromServer());
            ALL_PROCESSORS.put(ServiceType.VIDEO_ENDPOINT_CANDIDATE_FROM_SERVER.getValue(), new VideoCandidateFromServer());
            ALL_PROCESSORS.put(ServiceType.VIDEO_LEFT_ROOM.getValue(), new LeaveRoom());
            ALL_PROCESSORS.put(ServiceType.VIDEO_SUBSCRIBE_TRACK.getValue(), new SubscribeTrack());
            ALL_PROCESSORS.put(ServiceType.VIDEO_UNPUBLISH_TRACK.getValue(), new UnpublishVideoTrack());
            ALL_PROCESSORS.put(ServiceType.VIDEO_UNSUBSCRIBE_TRACK.getValue(), new UnsubscribeVideoTrack());
            ALL_PROCESSORS.put(ServiceType.VIDEO_ROOM_JOINED_FROM_SERVER.getValue(), new ParticipantJoinRoom());
            ALL_PROCESSORS.put(ServiceType.VIDEO_TRACK_ADDED_FROM_SERVER.getValue(), new VideoTrackAdded());
            ALL_PROCESSORS.put(ServiceType.VIDEO_TRACK_REMOVED_FROM_SERVER.getValue(), new VideoTrackRemoved());
            ALL_PROCESSORS.put(ServiceType.VIDEO_ROOM_LEFT_FROM_SERVER.getValue(), new ParticipantLeftRoom());
            ALL_PROCESSORS.put(ServiceType.VIDEO_ROOM_SEND_MSG.getValue(), new SendRoomMessage());
            ALL_PROCESSORS.put(ServiceType.VIDEO_ROOM_MSG_FROM_SERVER.getValue(), new RoomMessageFromServer());

            ALL_PROCESSORS.put(ServiceType.CHECK_EXIST_CALL.getValue(), new CheckExitsCall());

            // Chat
            ALL_PROCESSORS.put(ServiceType.CHAT_CREATE_CONVERSATION.getValue(), new CreateConversation());
            ALL_PROCESSORS.put(ServiceType.CHAT_DELETE_CONVERSATION.getValue(), new DeleteConversation());
            ALL_PROCESSORS.put(ServiceType.CHAT_CONVERSATION_LOAD.getValue(), new ChatConversationLoad());
            ALL_PROCESSORS.put(ServiceType.CHAT_MESSAGE.getValue(), new ChatMessage());
            ALL_PROCESSORS.put(ServiceType.CHAT_MESSAGE_FROM_SERVER.getValue(), new ChatMessageFromServer());
            ALL_PROCESSORS.put(ServiceType.CHAT_MESSAGE_LOAD.getValue(), new ChatMessageLoad());
            ALL_PROCESSORS.put(ServiceType.CHAT_MESSAGE_REPORT_FROM_SERVER.getValue(), new ChatMessageReportFromServer());
            ALL_PROCESSORS.put(ServiceType.CHAT_MESSAGE_REPORT.getValue(), new ChatMessageReport());
            ALL_PROCESSORS.put(ServiceType.GET_USER_INFO.getValue(), new UserInfo());
            ALL_PROCESSORS.put(ServiceType.GET_CONVERSATION.getValue(), new GetConversation());
            ALL_PROCESSORS.put(ServiceType.ADD_PARTICIPANTS.getValue(), new AddParticipants());
            ALL_PROCESSORS.put(ServiceType.REMOVE_PARTICIPANTS.getValue(), new RemoveParticipants());
            ALL_PROCESSORS.put(ServiceType.CHAT_REMOVE_PARTICIPANT_FROM_SERVER.getValue(), new ChatRemoveParticipantFromServer());
            ALL_PROCESSORS.put(ServiceType.DELETE_MESSAGES.getValue(), new DeleteMessages());
            ALL_PROCESSORS.put(ServiceType.UPDATE_CONVERSATION.getValue(), new UpdateConversation());
            ALL_PROCESSORS.put(ServiceType.CHAT_BLOCK_USER.getValue(), new ChatBlock());
            ALL_PROCESSORS.put(ServiceType.CHAT_CONVERSATION_FOR_USERS.getValue(), new GetConversationByParticipants());
            ALL_PROCESSORS.put(ServiceType.CHAT_UNREAD_CONVERSATION_COUNT.getValue(), new GetTotalUnread());
            ALL_PROCESSORS.put(ServiceType.CHAT_PIN_MESSAGE.getValue(), new PinMessage());
            ALL_PROCESSORS.put(ServiceType.CHAT_PIN_MESSAGE_FROM_SERVER.getValue(), new PinMessageFromServer());
            ALL_PROCESSORS.put(ServiceType.CHAT_EDIT_MESSAGE.getValue(), new EditMessage());
            ALL_PROCESSORS.put(ServiceType.CHAT_EDIT_MESSAGE_FROM_SERVER.getValue(), new EditMessageFromServer());
            ALL_PROCESSORS.put(ServiceType.CHAT_REVOKE_MESSAGE.getValue(), new RevokeMessages());
            ALL_PROCESSORS.put(ServiceType.CHAT_REVOKE_MESSAGE_FROM_SERVER.getValue(), new RevokeMessagesFromServer());
            ALL_PROCESSORS.put(ServiceType.CHAT_CONVERSATION_ATTACHMENT.getValue(), new ChatConversationAttachment());
            ALL_PROCESSORS.put(ServiceType.CHAT_SET_ROLE.getValue(), new SetChatRole());
            ALL_PROCESSORS.put(ServiceType.GET_MESSAGES_INFO.getValue(), new GetMessages());
            ALL_PROCESSORS.put(ServiceType.CHAT_USER_BEGIN_TYPING.getValue(), new ChatUserBeginTyping());
            ALL_PROCESSORS.put(ServiceType.CHAT_USER_END_TYPING.getValue(), new ChatUserEndTyping());
            ALL_PROCESSORS.put(ServiceType.CHAT_USER_BEGIN_TYPING_NOTIFICATION.getValue(), new ChatUserBeginTypingNotification());
            ALL_PROCESSORS.put(ServiceType.CHAT_USER_END_TYPING_NOTIFICATION.getValue(), new ChatUserEndTypingNotification());
            ALL_PROCESSORS.put(ServiceType.CHAT_CONVERSATION_ENDED_NOTIFICATION.getValue(), new ChatConversationEnd());
            ALL_PROCESSORS.put(ServiceType.CHAT_JOIN_OA_CONVERSATION.getValue(), new ChatJoinOaConversation());

            // Chat for customer support
            ALL_PROCESSORS.put(ServiceType.CHAT_ROUTE_TO_AGENT.getValue(), new ChatRouteToAgent());
            ALL_PROCESSORS.put(ServiceType.CHAT_AGENT_RESPONSE.getValue(), new ChatAgentResponse());
            ALL_PROCESSORS.put(ServiceType.END_CHAT.getValue(), new EndChat());
            ALL_PROCESSORS.put(ServiceType.RATE_CHAT.getValue(), new RateChat());
            ALL_PROCESSORS.put(ServiceType.CHAT_USER_UPDATE_INFO.getValue(), new UpdateUserInfo());
            ALL_PROCESSORS.put(ServiceType.TIMEOUT_ROUTE_TO_AGENT.getValue(), new ChatRequestTimeoutToAgent());
            ALL_PROCESSORS.put(ServiceType.TIMEOUT_ROUTE_TO_QUEUE.getValue(), new ChatRequestTimeoutToQueue());
            ALL_PROCESSORS.put(ServiceType.CHAT_TRANSFER.getValue(), new TransferChat());
            ALL_PROCESSORS.put(ServiceType.CHAT_TRANSFER_FROM_SERVER.getValue(), new TransferChatFromServer());
            ALL_PROCESSORS.put(ServiceType.AGENT_CONTINUE_CHATTING.getValue(), new AgentContinueChatting());
            ALL_PROCESSORS.put(ServiceType.CHAT_TRANSFER_RESPONSE.getValue(), new ChatTransferResponse());
            ALL_PROCESSORS.put(ServiceType.CHAT_SEND_TRANSCRIPT.getValue(), new ChatSendTranscript());
            ALL_PROCESSORS.put(ServiceType.CHAT_REQUEST_LOAD.getValue(), new ChatRequestLoad());
            ALL_PROCESSORS.put(ServiceType.XCHAT_LOAD_CUSTOMER_CONVERSATION_LIST.getValue(), new XChatLoadCustomerConversationList());
            ALL_PROCESSORS.put(ServiceType.XCHAT_LOAD_CONVERSATION.getValue(), new XChatLoadConversation());
            ALL_PROCESSORS.put(ServiceType.XCHAT_LOAD_MESSAGE.getValue(), new XChatLoadMessage());
            ALL_PROCESSORS.put(ServiceType.XCHAT_GET_CONVERSATION_INFO.getValue(), new XChatGetConversation());

            // Video call via room
            ALL_PROCESSORS.put(ServiceType.VIDEO_ROOM_MAKE_CALL.getValue(), new VideoRoomMakeCall());
            ALL_PROCESSORS.put(ServiceType.VIDEO_ROOM_CALL_INVITE.getValue(), new VideoRoomCallInvite());
            ALL_PROCESSORS.put(ServiceType.VIDEO_ROOM_CALL_STATE_FROM_SERVER.getValue(), new VideoCallStateChange());
            ALL_PROCESSORS.put(ServiceType.VIDEO_ROOM_END_CALL.getValue(), new VideoRoomEndCall());
            ALL_PROCESSORS.put(ServiceType.VIDEO_ROOM_END_CALL_FROM_SERVER.getValue(), new VideoEndCallFromServer());
            ALL_PROCESSORS.put(ServiceType.VIDEO_ROOM_CALL_INVITE_CANCEL.getValue(), new VideoRoomCallCancel());
            ALL_PROCESSORS.put(ServiceType.VIDEO_ROOM_CALL_STATE.getValue(), new VideoRoomCallState());
            ALL_PROCESSORS.put(ServiceType.VIDEO_ROOM_ENABLE_DISABLE_AUDIO_VIDEO.getValue(), new VideoRoomEnableDisableVideo());
            ALL_PROCESSORS.put(ServiceType.VIDEO_ROOM_ENABLE_DISABLE_AUDIO_VIDEO_NOTIFICATION.getValue(), new VideoRoomEnableDisableVideoNotification());
        }
    }


    public static ProcessorBase getProcessor(short service) {
        return ProcessorHolder.ALL_PROCESSORS.get(service);
    }

    abstract public void process(StringeeClient client, Packet packet);
}
