package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.network.tcpclient.packet.Packet;
import com.stringee.video.StringeeVideoTrack;

import org.json.JSONException;

public class PublishVideoTrack extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                StatusListener listener = Common.statusListenerMap.get(requestId);
                if (r == 0) {
                    StringeeVideoTrack videoTrack = client.getLocalVideoTrackMap().get(requestId);
                    client.getLocalVideoTrackMap().remove(requestId);
                    String serverTrackId = packet.getFieldString("serverTrackId");
                    String roomId = packet.getFieldString("roomId");
                    String serverPcId = packet.getFieldString("serverPcId");
                    if (videoTrack != null) {
                        videoTrack.setUserId(client.getUserId());
                        videoTrack.setRoomId(roomId);
                        videoTrack.setId(serverTrackId);
                        videoTrack.setPcId(serverPcId);
                        videoTrack.publish(client.getContext());
                    }
                    if (listener != null) {
                        listener.onSuccess();
                    }
                } else {
                    if (listener != null) {
                        listener.onError(new StringeeError(r, packet.optFieldString("message", "Failed to publish the video track")));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(PublishVideoTrack.class, e);
            }
        });
    }
}
