package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.database.DBHandler;
import com.stringee.exception.StringeeError;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.Conversation.State;
import com.stringee.messaging.StringeeChange;
import com.stringee.messaging.User;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class RemoveParticipants extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                CallbackListener<List<User>> callbackListener = Common.callbackListenerMap.get(requestId);
                DBHandler dbHandler = DBHandler.getInstance(client.getContext());
                boolean isLeft = false;
                if (r == 0) {
                    JSONArray parsArray = packet.optFieldJSONArray("removed");
                    String[] userIds = new String[parsArray.length()];
                    List<User> users = new ArrayList<>();
                    String convId = packet.getFieldString("convId");
                    Conversation conversation = dbHandler.getConversationByRemoteId(convId, client.getUserId());
                    if (!Utils.isEmpty(parsArray)) {
                        for (int i = 0; i < parsArray.length(); i++) {
                            JSONObject jsonObject = parsArray.getJSONObject(i);
                            String userId = jsonObject.optString("user");
                            String name = jsonObject.optString("displayName");
                            String avatar = jsonObject.optString("avatarUrl");

                            User user = new User(userId);
                            user.setName(name);
                            user.setAvatarUrl(avatar);
                            users.add(user);

                            userIds[i] = userId;
                            if (userId.equals(client.getUserId())) {
                                isLeft = true;
                            }

                            if (conversation != null) {
                                if (!Utils.isEmpty(conversation.getParticipants())) {
                                    for (int j = 0; j < conversation.getParticipants().size(); j++) {
                                        if (userId.equals(conversation.getParticipants().get(j).getUserId())) {
                                            conversation.getParticipants().remove(j);
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }

                    if (isLeft && conversation != null) {
                        conversation.setState(State.LEFT);
                    }

                    client.executeDbExecutor(() -> {
                        dbHandler.deleteParticipants(convId, userIds);
                        if (conversation != null) {
                            dbHandler.syncConversationToLocalDb(client.getUserId(), conversation);
                        }
                    });

                    if (callbackListener != null) {
                        callbackListener.onSuccess(users);
                    }

                    if (conversation != null) {
                        EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.UPDATE, conversation));
                    }
                } else {
                    String message = packet.getFieldString("message");
                    if (callbackListener != null) {
                        callbackListener.onError(new StringeeError(r, message));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(RemoveParticipants.class, e);
            }
        });
    }
}
