package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.listener.StringeeRoomListener;
import com.stringee.network.tcpclient.packet.Packet;
import com.stringee.video.RemoteParticipant;
import com.stringee.video.StringeeRoom;

import org.json.JSONObject;

public class RoomMessageFromServer extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            String roomId = packet.optFieldString("roomId");
            JSONObject msgObject = packet.optFieldJSONObject("msg");
            JSONObject fromObject = packet.optFieldJSONObject("fromUser");
            String userId = fromObject.optString("userId");
            RemoteParticipant remoteParticipant = new RemoteParticipant(userId);

            StringeeRoom room = client.getRoomMap().get(roomId);
            if (room != null) {
                StringeeRoomListener listener = room.getListener();
                if (listener != null) {
                    listener.onMessage(room, msgObject, remoteParticipant);
                }
            }
        });
    }
}
