package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.common.event.EventManager;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.messaging.Conversation;
import com.stringee.messaging.StringeeChange;
import com.stringee.messaging.listeners.CallbackListener;
import com.stringee.network.tcpclient.packet.Packet;

import org.json.JSONException;

public class SetChatRole extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                StatusListener statusListener = Common.statusListenerMap.get(requestId);
                if (r == 0) {
                    if (statusListener != null) {
                        statusListener.onSuccess();
                    }
                    String convId = packet.getFieldString("convId");
                    client.getConversationFromServer(convId, new CallbackListener<Conversation>() {
                        @Override
                        public void onSuccess(Conversation conv) {
                            EventManager.sendChatChangeEvent(client, new StringeeChange(StringeeChange.Type.UPDATE, conv));
                        }
                    });
                } else {
                    if (statusListener != null) {
                        statusListener.onError(new StringeeError(r, packet.optFieldString("message", "Error")));
                    }
                }
            } catch (JSONException e) {
                Utils.reportException(SetChatRole.class, e);
            }
        });
    }
}
