package com.stringee.network.processor;

import com.stringee.StringeeClient;
import com.stringee.common.Common;
import com.stringee.common.Utils;
import com.stringee.exception.StringeeError;
import com.stringee.listener.StatusListener;
import com.stringee.network.tcpclient.packet.Packet;
import com.stringee.video.StringeeRoom;
import com.stringee.video.StringeeVideoTrack;

import org.json.JSONException;

public class SubscribeTrack extends ProcessorBase {
    @Override
    public void process(StringeeClient client, Packet packet) {
        client.executeExecutor(() -> {
            packet.decodeJson();
            try {
                int r = packet.getFieldInt("r");
                int requestId = packet.getFieldInt("requestId");
                StatusListener listener = Common.statusListenerMap.get(requestId);
                if (r == 0) {
                    String trackId = packet.optFieldString("serverTrackId");
                    String serverPcId = packet.optFieldString("serverPcId");
                    String roomId = packet.optFieldString("roomId");
                    StringeeRoom room = client.getRoomMap().get(roomId);
                    if (room == null) {
                        return;
                    }
                    StringeeVideoTrack videoTrack = room.getVideoTrackMap().get(trackId);
                    if (videoTrack != null) {
                        room.getVideoTrackMap().remove(trackId);
                        videoTrack.setPcId(serverPcId);
                        room.getVideoTrackMap().put(videoTrack.getLocalId(), videoTrack);
                        videoTrack.subscribe(client.getContext());
                    }
                    if (listener != null) {
                        listener.onSuccess();
                    }
                } else {
                    if (listener != null) {
                        listener.onError(new StringeeError(r, packet.optFieldString("message", "Failed to subscribe the video track")));
                    }
                }

            } catch (JSONException e) {
                Utils.reportException(SubscribeTrack.class, e);
            }
        });
    }
}
